unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes,
  System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, System.IOUtils,
  FMX.Controls.Presentation, FMX.StdCtrls, FMX.Edit, {$IFDEF MSWINDOWS} FMX.Platform.Win, {$ENDIF}Inifiles,

  FMX.BASS,
  BASSMix;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    btnSave: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
  private
    { Private declarations }

  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Channel0: HSTREAM;
  Channel1: HSTREAM;
  Floatsupport: DWORD;
  ChannelMix: HSTREAM;

implementation

{$R *.fmx}
{ function ProgDir: string; only for Windows
  begin
  Result := ExtractFilePath(ParamStr(0));
  end; }

procedure SaveSettingString(Section, Name, Value: string);
var
  ini: TIniFile; // Androidcompatible
begin
  ini := TIniFile.Create(System.IOUtils.TPath.GetDocumentsPath + System.SysUtils.PathDelim + 'config.ini');
  try
    ini.WriteString(Section, Name, Value);
  finally
    ini.Free;
  end;
end;

function LoadSettingString(Section, Name, Value: string): string;
var
  ini: TIniFile; // Androidcompatible
begin
  ini := TIniFile.Create(System.IOUtils.TPath.GetDocumentsPath + System.SysUtils.PathDelim + 'config.ini');
  try
    Result := ini.ReadString(Section, Name, Value);
  finally
    ini.Free;
  end;
end;

procedure Error(msg: string);
begin
  ShowMessage(msg + #13#10 + #13#10 + '(error code: ' + (BASS_ErrorGetCode).ToString + ')');
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  if not BASS_Init(-1, 44100, 0,
{$IFDEF MSWINDOWS}
    WindowHandleToPlatform(Self.Handle).Wnd // for windows
{$ELSE}
    Form1.Handle // for android
{$ENDIF}
    , nil) then
    Error('Bass Init Error');
  // Dont forget to create the Mixer
  ChannelMix := BASS_Mixer_StreamCreate(44100, 2, 0);
  // Load Settings
  Edit1.Text := LoadSettingString('Settings', 'WAV1', '80s-KICK.wav');
  Edit2.Text := LoadSettingString('Settings', 'WAV2', '80s-SNARE.wav');
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Bass_Free();
end;

procedure TForm1.btnSaveClick(Sender: TObject);
begin
  SaveSettingString('Settings', 'WAV1', Edit1.Text);
  SaveSettingString('Settings', 'WAV2', Edit2.Text);
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  file1, file2: string;
begin

  file1 := Edit1.Text;
  file2 := Edit2.Text;

  { will work }

  if Channel0 <> 0 then
    Bass_StreamFree(Channel0); // Check if still the Channel exist if yes free it

  Channel0 := BASS_StreamCreateFile(false, pchar(file1), 0, 0, BASS_STREAM_DECODE or Bass_Unicode); // ! BASS_UNICODE
  if Channel0 <> 0 then
    BASS_Mixer_StreamAddChannel(ChannelMix, Channel0, 0)
  else
    Error('Cannot add Channel0');

  if Channel1 <> 0 then
    Bass_StreamFree(Channel1);

  Channel1 := BASS_StreamCreateFile(false, pchar(file2), 0, 0, BASS_STREAM_DECODE or Bass_Unicode);
  if Channel0 <> 0 then
    BASS_Mixer_StreamAddChannel(ChannelMix, Channel1, 0)
  else
    Error('Cannot add Channel1');

  BASS_ChannelPlay(ChannelMix, false);

end;

end.
